/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx__memory_pool.c,v 1.4 2005/03/29 21:02:21 eugene Exp $";

#include "mx__block.h"
#include "mx__memory_pool.h"

void
mx__memory_pool_init(struct mx__memory_pool *pool, char *base,
		     int length, int max)
{
  pool->base = base;
  pool->length = length;
  pool->max = max;
  mx__make_chain(&pool->block, base, length, pool->max);
}

char *
mx__memory_pool_alloc(struct mx__memory_pool *pool, int length)
{
  return mx__alloc_block(&pool->block);
}

void
mx__memory_pool_free(struct mx__memory_pool *pool, char *p,
		     int length)
{
  mx__free_block(&pool->block, p);
}

